var TrackWord = $.extend(TrackPuzzle, {

     initSpecific: function(puzzleId, serviceURL, isTrackingActive) {

        this.puzzleStart = this.getCurrentTime();
        this.lastWordTime = this.puzzleStart;
    },

    saveGameEndTime: function() {
        if (!this.isTrackingActive)
            return;

        var gameTotalTime = this.getCurrentTime() - this.puzzleStart;
        this.saveStat('game_duration', gameTotalTime);
    },

    savePuzzleCompletion: function() {
        if (!this.isTrackingActive)
            return;
        
        var completePercent = basePuzzle.GetCompletionPercentage();
        
        this.puzzleCompletion = completePercent.toFixed(2);

        this.saveStat('game_completion', this.puzzleCompletion);
    },
    saveWordFound: function(baseWord, completeWord) {
        if (!this.isTrackingActive)
            return;
        
        var word = baseWord + "-" + completeWord;
        var timeSpent = this.getCurrentTime() - this.lastWordTime;
        
        this.saveStat('word_found_time', word, timeSpent);

        this.lastWordTime = this.getCurrentTime();
    },
    saveWrongWord: function(baseWord, wrongWord) {
        if (!this.isTrackingActive)
            return;
        
        var word = baseWord + "-" + wrongWord;
        var timeSpent = this.getCurrentTime() - this.lastWordTime;
        
        this.saveStat('wrong_word', word, timeSpent);

        this.lastWordTime = this.getCurrentTime();
    },
    saveSpotFound: function(round, spot) {
        if (!this.isTrackingActive)
            return;
        
        var name = round + "-" + spot;
        var timeSpent = this.getCurrentTime() - this.lastWordTime;
        
        this.saveStat('spot_found_time', name, timeSpent);

        this.lastWordTime = this.getCurrentTime();
    },

    saveRoundCompleted: function(baseWord, roundName) {
        if (!this.isTrackingActive)
            return;

        var word = baseWord + "-" + roundName;
        var timeSpent = this.getCurrentTime() - this.puzzleStart;

        this.saveStat('round_completed_time', word, timeSpent);

        this.lastWordTime = this.getCurrentTime();
    },

    didSendPuzzleStatistics: function() {
        this.puzzleStart = this.getCurrentTime();
        this.lastWordTime = this.puzzleStart;
    },
    lastWordTime: undefined,
    puzzleStart: undefined
});