//Check HTC Android 2 built-in browser
var isAndroidHTC = navigator.userAgent.match(/HTC/i) && !navigator.userAgent.match(/Android 4/i);

/**
 * Object definition for handling keyboard events for Sudoku
 */
var SudokuInput = $.extend(PuzzleInput, {
    /**
     * Returns true if a valid sudoku input key is pressed (only numbers)
     */
    isValidInput: function(event) {
        return ((event.keyCode >= 49 && event.keyCode <= 57) || (event.which >= 49 && event.which <= 57));
    }
});

var SudokuFlags = {
    HINT: 1,
    SOLUTION: 2,
    PENCIL_MODE: 4,
};

/**
 * Object definition for sudoku
 */
var Sudoku = $.extend(Puzzle, {
    inputFocused: false,
    solutionTimeout: -1,

    /**
     * Initializes components and event listeners for sudoku
     * Currently, clue clicks, cell clicks and key inputs are
     * being listened by this class.
     */
    init: function(options) {
        //Get options
        $.extend(this.defaults, options);

        this.helpFlags = this.HELP_FLAG_NONE;

        this.defaults.pencilMode = false;
        
        //Insert input field
        this.insertUserInputField();
        
        //Set parent objects
        this.parentObjects.grid = $(this.defaults.gridId);

        $('#pencil-mode').on('touchstart mousedown', function(event) {
            if ($(Sudoku.defaults.userInputId).is(':focus'))
            {
                Sudoku.inputFocused = true;

                setTimeout(function() {
                    Sudoku.inputFocused = false;
                }, 500);
            }
        });

        $('#pencil-mode').click(function(event) {
            $(this).toggleClass('active');

            if ($(this).hasClass('active'))
            {
                TrackPuzzle.flags |= SudokuFlags.PENCIL_MODE;
                Sudoku.defaults.pencilMode = true;
                $(this).attr('src', $(this).attr('src').replace(/inactive-/, ''));

                if (Sudoku.inputFocused)
                {
                    $(Sudoku.defaults.userInputId).focus();
                    setTimeout(function() {
                        Sudoku.hightlightInputCell($(Sudoku.lastSelected.cell));
                    }, 10);
                }
            }
            else
            {
                Sudoku.defaults.pencilMode = false;
                $(this).attr('src', $(this).attr('src').replace(/black/, 'inactive-black'));
            }
        });

        var in_grid = false;
        $('#puzzle-grid').click(function(event) {
            in_grid = true;
        });

        $('body').click(function() {
            if (!in_grid)
                $('.cell').removeClass('active');

            in_grid = false;
        });

        var androidChrome = (navigator.userAgent.toLowerCase().indexOf("android") > -1 && navigator.userAgent.toLowerCase().indexOf("chrome") > -1);
        var isMobileIE = navigator.userAgent.toLowerCase().indexOf("iemobile") > -1;
        var hid = true;

        if (!isMobileIE)
        {
            $(".cell-input-click").hide();
            hid = false;
        }

        //CELL CLICKS
        $(this.defaults.cellsId).click(function(event) {               
            //Determine if the source of event is user click
            if (event.originalEvent) 
                Sudoku.cellEventSource = EventSource.CellClick;

            if (hid)
            {
                $(".cell-input-click").hide();
                hid = false;
            }
                
            //Deselect old cells
            Sudoku.deselectCells();
            //Mark input cell
            Sudoku.hightlightInputCell(this);
            //Reposition user input field according to cell
            Sudoku.repositionUserInputField();
            //Enable user input
            $(Sudoku.defaults.userInputId).focus();
        });

        if (androidChrome || isMobileIE)
        {
            $(this.defaults.userInputId).keyup(function(event) {
                if (!isMobileIE)
                {
                    SudokuInput.setDeleteHack(true);
                }
                
                var inputLastChar = SudokuInput.getUserInput(event, Sudoku.defaults.userInputId);

                if (inputLastChar == '')
                    return;

                if (SudokuInput.isBackspace(event) || SudokuInput.isDeleteKey(event)) // Android delete!
                {
                    //Backspace
                    if (!$(Sudoku.lastSelected.cell).hasClass(Sudoku.defaults.hintCellClass))
                    {
                        //Set cell text to empty value
                        Sudoku.setCellValue(Sudoku.lastSelected.cell, "");
                        return;
                    }
                }

                if (SudokuInput.isValidInput(event))
                {
                    if (!$(Sudoku.lastSelected.cell).hasClass(Sudoku.defaults.hintCellClass))
                    {
                        if (Sudoku.defaults.pencilMode)
                        {
                            if ($(Sudoku.lastSelected.cell).find('.pencil-overlay').length == 0)
                            {
                                Sudoku.setCellValue(Sudoku.lastSelected.cell, Sudoku.getPencilOverlay());

                                var cellWidth = $(Sudoku.lastSelected.cell).width();
                                var cellHeight = $(Sudoku.lastSelected.cell).height();
                                var pencilWidth = $(Sudoku.lastSelected.cell).find('.pencil-overlay').width();
                                var pencilHeight = $(Sudoku.lastSelected.cell).find('.pencil-overlay').height();
                                
                                $(Sudoku.lastSelected.cell).find('.pencil-overlay').css('top', ((cellHeight - pencilHeight) / 2) + 'px');
                                $(Sudoku.lastSelected.cell).find('.pencil-overlay').css('left', ((cellWidth - pencilWidth) / 2) + 'px');
                            }

                            Sudoku.togglePencilOverlayValue(Sudoku.lastSelected.cell, inputLastChar);
                        }
                        else
                        {
                            //Set cell text to inputted value
                            Sudoku.setCellValue(Sudoku.lastSelected.cell, inputLastChar);
                        }
                    }
                }
                else
                {
                //console.log("Key is not valid!");
                }

                this.lastInput = inputLastChar;
            });
        }
        else
        {
            //Backspace and arrow keys should be handled with "keydown"
            $(this.defaults.userInputId).keydown(function(event) {
                //Get user input
                SudokuInput.getUserInput(event, Sudoku.defaults.userInputId, false);

                if (SudokuInput.isBackspace(event) || SudokuInput.isDeleteKey(event)) 
                {
                    //Backspace
                    if (!$(Sudoku.lastSelected.cell).hasClass(Sudoku.defaults.hintCellClass))
                    {
                        //Set cell text to empty value
                        Sudoku.setCellValue(Sudoku.lastSelected.cell, "");
                    }
                }
                else if (SudokuInput.isUp(event)) 
                {
                    //Up arrow
                    Sudoku.focusCellAtDirection(Sudoku.lastSelected.cell, PuzzleDirection.UP);
                }
                else if (SudokuInput.isRight(event)) 
                {
                    //Right arrow
                    Sudoku.focusCellAtDirection(Sudoku.lastSelected.cell, PuzzleDirection.RIGHT);
                }
                else if (SudokuInput.isDown(event)) 
                {
                    //Down arrow
                    Sudoku.focusCellAtDirection(Sudoku.lastSelected.cell, PuzzleDirection.DOWN);
                }
                else if (SudokuInput.isLeft(event)) 
                {
                    //Left arrow
                    Sudoku.focusCellAtDirection(Sudoku.lastSelected.cell, PuzzleDirection.LEFT);
                }
                else
                {
                //console.log("Key is not valid!");
                }
            });

            //USER INPUT should be handled with "keypress"
            $(this.defaults.userInputId).keypress(function(event) {
                //Get user input
                var inputLastChar = SudokuInput.getUserInput(event, Sudoku.defaults.userInputId);
                
                if (SudokuInput.isValidInput(event))
                {
                    if (!$(Sudoku.lastSelected.cell).hasClass(Sudoku.defaults.hintCellClass))
                    {
                        if (Sudoku.defaults.pencilMode)
                        {
    						if ($(Sudoku.lastSelected.cell).find('.pencil-overlay').length == 0)
                            {
                                Sudoku.setCellValue(Sudoku.lastSelected.cell, Sudoku.getPencilOverlay());

                                var cellWidth = $(Sudoku.lastSelected.cell).width();
                                var cellHeight = $(Sudoku.lastSelected.cell).height();
                                var pencilWidth = $(Sudoku.lastSelected.cell).find('.pencil-overlay').width();
                                var pencilHeight = $(Sudoku.lastSelected.cell).find('.pencil-overlay').height();
                                
                                $(Sudoku.lastSelected.cell).find('.pencil-overlay').css('top', ((cellHeight - pencilHeight) / 2) + 'px');
                                $(Sudoku.lastSelected.cell).find('.pencil-overlay').css('left', ((cellWidth - pencilWidth) / 2) + 'px');
                            }

    						Sudoku.togglePencilOverlayValue(Sudoku.lastSelected.cell, inputLastChar);
                        }
                        else
                        {
                            //Set cell text to inputted value
                            Sudoku.setCellValue(Sudoku.lastSelected.cell, inputLastChar);
                        }
                    }
                }
                else
                {
                //console.log("Key is not valid!");
                }
            });
        }
        
        //Zoom buttons
        $(this.defaults.zoomInButton).click(function() {
            Puzzle.zoomIn();
        });
        
        $(this.defaults.zoomOutButton).click(function() {
            Puzzle.zoomOut();
        });
    },
    /**
     * Get a new pencil overlay
     */
    getPencilOverlay: function()
    {
        var pencilOverlay = "" +
					"<div class='pencil-overlay'>" +
						"<span class='overlay-1'>1</span> <span class='overlay-2 overlay-middle'>2</span> <span class='overlay-3'>3</span><br/>" +
						"<span class='overlay-4'>4</span> <span class='overlay-5 overlay-middle'>5</span> <span class='overlay-6'>6</span><br/>" +
						"<span class='overlay-7'>7</span> <span class='overlay-8 overlay-middle'>8</span> <span class='overlay-9'>9</span><br/>" +
					"</div>";

				return pencilOverlay;
    },
    /**
     * Inserts an input field to web page for user input
     */
    insertUserInputField: function() {
        var androidChrome = (navigator.userAgent.toLowerCase().indexOf("android") > -1 && navigator.userAgent.toLowerCase().indexOf("chrome") > -1);

        var userInput = document.createElement("input");
        userInput.id = this.defaults.userInputId.replace("#", "");
        userInput.type = isClientMobile ? "number" : "text";
        userInput.maxlength = "10";
        userInput.spellcheck = "false";
        userInput.style.top = "-10000px";
        userInput.style.width = androidChrome ? "10px" : "1px";
        userInput.style.height = androidChrome ? "10px" : "1px";
        userInput.style.fontSize = androidChrome ? "16px" : "16px"; // ios zooms < 16
        if (!androidChrome)
            userInput.style.opacity = "0.01";
        userInput.style.position = "absolute";
        userInput.style.zIndex = "-9999";
        userInput.style.marginLeft = "20px";
        userInput.tabIndex = "1";
        document.body.innerHTML = userInput.outerHTML + document.body.innerHTML;
    },
    repositionUserInputField: function() {
        //Scroll to input cell
        if (/*typeof(isClientMobile) !== undefined && isClientMobile && */this.lastSelected.cell) {
            var isMobileIE = navigator.userAgent.toLowerCase().indexOf("iemobile") > -1;
            var offx = isMobileIE ? -60 : 0;
            $(this.defaults.userInputId).css("top", $(this.lastSelected.cell).offset().top);
            $(this.defaults.userInputId).css("left", $(this.lastSelected.cell).offset().left + offx);
        }
    },
    /**
     * Invokes cell click event programatically
     */
    invokeCellClick: function(cell, eventSource) {
        this.cellEventSource = eventSource;
        $(cell).click();
    },
    /**
     * Highlights the cell that takes user input
     */
    hightlightInputCell: function(cell) {
        $(cell).addClass(this.defaults.selectedClass);
        this.lastSelected.cell = cell;
        TrackSd.saveCellStartTime(cell);
    },
    /**
     * Removes the highlight from selected cell & answer slot
     */
    deselectCells: function() {
        //Remove highlight from input cell
        if (this.lastSelected.cell != undefined)
        {
            $(this.lastSelected.cell).removeClass(this.defaults.selectedClass);
            this.lastSelected.cell = undefined;
        }
    },
    /**
     * Sets the value of a cell by setting inner HTML
     */
    setCellValue: function(cell, val) {
        $(cell).children(Sudoku.defaults.cellInputId).html(val);
        $(cell).removeClass(this.defaults.invalidCellClass);

        if(val != ''){
            Sudoku.createSolutionTimeout();}
            //createSolutionTimeout(Sudoku, Sudoku.solutionTimeout);}
    },
    /**
     * Toggle active for given number in pencil overlay
     */
    togglePencilOverlayValue: function(cell, val) {
        var overlay_value = $(cell).children(Sudoku.defaults.cellInputId).find('.overlay-' + val);
        
        if (overlay_value.hasClass('enabled'))
            overlay_value.removeClass('enabled');
        else
            overlay_value.addClass('enabled');
    },
    /**
     * Focuses next cell for user input. This function is used when user fills in an answer slot.
     */
    focusCellAtDirection: function(cell, direction) {
        //Get cell coordinates
        var cellDetails = cell.id.toString().split("-");
        var cellX = parseInt(cellDetails[1]);
        var cellY = parseInt(cellDetails[2]);
        
        //Determine the new cell coordinates based on given direction
        if (direction == PuzzleDirection.UP)
            cellY = ((cellY - 1) <= 0) ? Sudoku.size.height : (cellY - 1);
        else if (direction == PuzzleDirection.RIGHT)
            cellX = ((cellX + 1) > Sudoku.size.width) ? 1 : (cellX + 1);
        else if (direction == PuzzleDirection.DOWN)
            cellY = ((cellY + 1) > Sudoku.size.height) ? 1 : (cellY + 1);
        else if (direction == PuzzleDirection.LEFT)
            cellX = ((cellX - 1) <= 0) ? Sudoku.size.width : (cellX - 1);
        
        var nextCellId = "#cell-" + cellX + "-" + cellY;
        this.invokeCellClick(nextCellId, EventSource.KeyInput);
    },
    moveToNextHintCell: function() {
        var cellX = 1;
        var cellY = 1;
        
        //Get cell coordinates
        if (Puzzle.lastSelected.cell) {
            var cellDetails = Puzzle.lastSelected.cell.id.toString().split("-");
            cellX = parseInt(cellDetails[1]);
            cellY = parseInt(cellDetails[2]);
            
            if (cellY + 1 > Puzzle.size.height) {
                cellY = 1;
                cellX = ((cellX + 1) > Puzzle.size.width) ? 1 : (cellX + 1);
            }
            else {
                cellY = cellY + 1;
            }
        }
        
        var nextCellId = "#cell-" + cellX + "-" + cellY;
        this.invokeCellClick(nextCellId, EventSource.CellClick);
    },
    fixHeightHTCAndroid: function()
    {
        if (isAndroidHTC) {
            setTimeout(function() {
                var heightRequired = $("#puzzle-grid").height();
                
                if ($(".banner-image").length > 0)
                    heightRequired += $(".banner-image").height();
                
                //Add keyboard height
                heightRequired += 300;
                //Set body height
                $("body").height(heightRequired);
            }, 1000);
        }
    }
});

$(document).ready(function() {
    Puzzle.updateOrientation();
    window.onorientationchange = function() {
        Puzzle.updateOrientation();
    };
    
    //Fix for toolbar orientation on mobile
    if (isClientMobile) {
        $(".puzzle .puzzle-toolbar").css("white-space", "normal");
        $(".puzzle .puzzle-toolbar").css("text-align", "center");
    }
    
    var cellAmount = $('#puzzle-grid').data('x');
    function resizePuzzle(opts) {
        var defaultOptions =
        {
            cells : cellAmount
        };
        if(typeof opts == 'object') {
            opts = $.extend(defaultOptions, opts);
        } else {
            opts = defaultOptions;
        }

        var width = (window.innerWidth / opts.cells);
        var oddSizeMargin = ( opts.cells & 1 ) ? 2 : 1;
        var size = (Math.floor(width) - oddSizeMargin);
        size = Math.min(size, 40);

        //console.log('width %d, height %d, amount of cells %d', width, height, opts.cells);

        $('#puzzle-grid .cell').css(
        {
            width: size,
            height: size,
            lineHeight: (size + 'px')
        });

        if (opts.cells >= 19)
        {
            var imageSize = (size*5);
            var imagePos = (size*7);
            $('#puzzle-grid .center-image').css(
            {
                width: (imageSize -1),
                height: (imageSize -1),
                top: imagePos,
                left: imagePos
            });
        }
        
        if (Puzzle.repositionUserInputField) {
            Puzzle.repositionUserInputField();
        }
        
        Sudoku.fixHeightHTCAndroid();

        $('.pencil-overlay').each(function() {
            var cell = $(this).closest('.cell');

            var cellWidth = cell.width();
            var cellHeight = cell.height();
            var pencilWidth = $(this).width();
            var pencilHeight = $(this).height();
            
            $(this).css('top', ((cellHeight - pencilHeight) / 2) + 'px');
            $(this).css('left', ((cellWidth - pencilWidth) / 2) + 'px');
        });

    }
    resizePuzzle();

    var resizeMe;
    $(window).resize(function() {
        clearTimeout(resizeMe); // lets make sure we only run th function once after a 100 ms timeout (cheap onResizeEnd)
        resizeMe = setTimeout(resizePuzzle, 100);
    });
});
