/**
  * browser detection
  * following checks:
  * -----------------
  * ismobile (android, ios, blackberry, playbook)
  * ismac isios isios4 isipad
  * isandroid (all versions) isandroid2 isandroid3 isandroid4
  * isblackberry isplaybook
  * ischrome
  * ismozilla
  * iswebkit
  * isopera isopera12
  * isie isieold (8 and below) isie7 isie8 isie9 isie10 isie9mobile 
isie7mobile
  * cantouch
  * hasmstouch haspointerlock hastransform hastransition
  *
  * etc : featureDetection.browser.hastranslate3d
  */
var featureDetection = new function() {
     var browserdetected = false;
     var getBrowserDetection = function() {
             if(browserdetected) return browserdetected;
             var e = document.createElement("DIV");
             var t = {};
             t.haspointerlock = "pointerLockElement" in document || 
"mozPointerLockElement" in document || "webkitPointerLockElement" in 
document;
             t.isopera = "opera" in window;
             t.isopera12 = t.isopera && "getUserMedia" in navigator;
             t.isie = "all" in document && "attachEvent" in e && !t.isopera;
             t.isieold = t.isie && !("msInterpolationMode" in e.style);
             t.isie7 = t.isie && !t.isieold && (!("documentMode" in 
document) || document.documentMode == 7);
             t.isie8 = t.isie && "documentMode" in document && 
document.documentMode == 8;
             t.isie9 = t.isie && "performance" in window && 
document.documentMode >= 9;
             t.isie10 = t.isie && "performance" in window && 
document.documentMode >= 10;
             t.isieold = t.isie && "performance" in window && 
document.documentMode <= 8;
             t.isie9mobile = /iemobile.9/i.test(navigator.userAgent);
             if(t.isie9mobile) t.isie9 = false;
             t.isie7mobile = !t.isie9mobile && t.isie7 && 
/iemobile/i.test(navigator.userAgent);
             t.ismozilla = "MozAppearance" in e.style;
             t.iswebkit = "WebkitAppearance" in e.style;
             t.ischrome = "chrome" in window;
             t.ischrome22 = t.ischrome && t.haspointerlock;
             t.cantouch = "ontouchstart" in document.documentElement;
             t.hasmstouch = window.navigator.msPointerEnabled || false;
             t.ismac = /Mac/i.test(navigator.platform);
             t.isios = t.cantouch && 
/iphone|ipad|ipod/i.test(navigator.platform);
             t.isipad = t.cantouch && /ipad/i.test(navigator.platform);
             t.isios4 = t.isios && !("seal" in Object);
             t.isandroid = /android/i.test(navigator.userAgent);
             t.issafari = /Safari/i.test(navigator.userAgent);
             t.isandroid2 = /android 2/i.test(navigator.userAgent);
             t.isandroid3 = /android 3/i.test(navigator.userAgent);
             t.isandroid4 = /android 4/i.test(navigator.userAgent);
             t.isplaybook = /PlayBook/i.test(navigator.userAgent);
             t.isblackberry = /BlackBerry/i.test(navigator.userAgent);
             t.ismobile = false;
             if(t.isios || t.isandroid || t.isblackberry || t.isplaybook) {
                 t.ismobile = true;
             }
             if(t.issafari && t.ischrome) {
                 t.issafari = false;
             }
             t.trstyle = false;
             t.hastransform = false;
             t.hastranslate3d = false;
             t.transitionstyle = false;
             t.hastransition = false;
             t.transitionend = false;
             var n = ["transform", "msTransform", "webkitTransform", 
"MozTransform", "OTransform"];
             for(var r = 0; r < n.length; r++) {
                 if(typeof e.style[n[r]] !== "undefined") {
                     t.trstyle = n[r];
                     break;
                 }
             }
             t.hastransform = t.trstyle != false;
             if(t.hastransform) {
                 e.style[t.trstyle] = "translate3d(1px,2px,3px)";
                 t.hastranslate3d = /translate3d/.test(e.style[t.trstyle]);
             }
             t.transitionstyle = false;
             t.prefixstyle = "";
             t.transitionend = false;
             var n = ["transition", "webkitTransition", "MozTransition", 
"OTransition", "OTransition", "msTransition", "KhtmlTransition"];
             var i = ["", "-webkit-", "-moz-", "-o-", "-o", "-ms-", 
"-khtml-"];
             var s = ["transitionend", "webkitTransitionEnd", 
"transitionend", "otransitionend", "oTransitionEnd", "msTransitionEnd", 
"KhtmlTransitionEnd"];
             for(var r = 0; r < n.length; r++) {
                 if(n[r] in e.style) {
                     t.transitionstyle = n[r];
                     t.prefixstyle = i[r];
                     t.transitionend = s[r];
                     break;
                 }
             }
             t.hastransition = t.transitionstyle;
             t.hasmousecapture = "setCapture" in e;
             e = null;
             browserdetected = t;
             return t;
         }
     this.browser = getBrowserDetection();
}

