var GameState = {
    isCookiesSupported: function() {
        //Set a temporary cookie value
        this.setCookie(this.defaults.tempCookieName, this.defaults.tempCookieValue);
        
        //Check if cookie was saved successfully
        if (this.getCookie(this.defaults.tempCookieName) == this.defaults.tempCookieValue)
            return true;
        else
            return false;
    },
    isLocalStorageSupported: function() {
        if (typeof(Storage) !== "undefined")
            return true;
        else
            return false;          
    },
    setCookieIdentifier: function(cookieId) {
        this.defaults.cookieName = cookieId;
    },
    setCookie: function(cookieName, value, exdays) {
        var exdate = new Date();
        exdate.setDate(exdate.getDate() + exdays);
        var cValue = escape(value) + ((exdays==null) ? "" : "; expires=" + exdate.toUTCString());
        document.cookie = cookieName + "=" + cValue;
    },
    getCookie: function(cookieName) {
        var i, x, y, ARRcookies = document.cookie.split(";");

        for (i = 0; i < ARRcookies.length; i++)
        {
            x = ARRcookies[i].substr(0, ARRcookies[i].indexOf("="));
            y = ARRcookies[i].substr(ARRcookies[i].indexOf("=") + 1);
            x = x.replace(/^\s+|\s+$/g, "");
            if (x == cookieName) {
                return unescape(y);
            }
        }
        
        return false;
    },
    setGameState: function(value) {
        var timeString = "";
        if (puzzleTimer && puzzleTimer.getSeconds) {
            timeString = ";" + puzzleTimer.getSeconds().toString();
        }

        value += timeString;
        if (this.isLocalStorageSupported())
            localStorage[this.defaults.cookieName] = value;
        else if(this.isCookiesSupported())
            this.setCookie(this.defaults.cookieName, value);
    },
    getGameState: function() {
        if (isCompetition)
            return false;

        var gameStateString = false;

        if (this.isLocalStorageSupported()) {
            gameStateString = localStorage[this.defaults.cookieName];
        }
        else if (this.isCookiesSupported()) {
            gameStateString = this.getCookie(this.defaults.cookieName);
        }

        if (gameStateString) {
            gameStateString = gameStateString.split(";");
            
            //Set time if available
            if (gameStateString.length > 1 && puzzleTimer && puzzleTimer.setTime)
            {
                puzzleTimer.setTime(gameStateString[1]);
            }
            //Return game state
            if (gameStateString.length > 0)
                return gameStateString[0];
            
        }
        
        return false;
    },
    clearGameState: function() {
        if (this.isCookiesSupported())
            this.setCookie(this.defaults.cookieName, "");
        else if (this.isLocalStorageSupported())
            localStorage[this.defaults.cookieName] = "";
    },
    defaults: {
        tempCookieName: "check-cookie-support",
        tempCookieValue: "can-support",
        cookieName: "puzzle_game_state",
        saveButton: "#save-game",
        gameStateLabel: "#game-state",
        blankAnswer: "_",
        timeoutId: undefined,
        timeoutDuration: 5000
    }
};