var SaveWordScrambler = $.extend(GameState, {
    init: function (cookieId) {
        //Set storage identifier
        this.setCookieIdentifier(cookieId);

        //Load quiz game
        if (!isCompetition) {
            if (dictionary != null)
            {
//                this.loadWordscramblerDB();
                //GS BUG# 3433
                this.loadWordscrambler();
                //GS BUG# 3433
            } else
            {
                this.loadWordscrambler();
            }
        }

        //Bind functionality to save button
        $(this.defaults.saveButton).click(function () {
            if (basePuzzle.isGameOver)
                return false;

            SaveWordScrambler.saveWordscrambler();

            return false;
        });

        //"CLEAR ALL" BUTTON CLICK
        $(Puzzle.defaults.clearButton).click(function () {

            SaveWordScrambler.clearWordscrambler();

            return false;
        });
    },
    clearWordscrambler: function () {
        //GS BUG# 2314
        $.confirm({
            title: '',
            content: 'Are you sure you want to clear the puzzle?',
            buttons: {
                Ok: {
                    btnClass: "btn-default puzzle",
                    action: function () {
                        TrackWord.sendPuzzleStatistics(true);

                        GameState.clearGameState();

                        puzzleTimer.reset();

                        basePuzzle.StartPuzzle(true);
                    }

                },
                Cancel: {
                    btnClass: "btn-default puzzle",
                    action: function () {

                    }
                }
            }
        });
        //GS BUG# 2314

//        if (confirm("Are you sure you want to clear the puzzle?")) {
//            TrackWord.sendPuzzleStatistics(true);
//
//            GameState.clearGameState();
//
//            puzzleTimer.reset();
//
//            basePuzzle.StartPuzzle(true);
//        }
    },
    saveWordscrambler: function () {

        var saveOBJ = "";

        if (dictionary != null)
        {
            saveOBJ = {
//                StartIndex: aDB.start_index,
//                Completed: basePuzzle.GetCompleteWords()

//GS BUG# 3433
                StartIndex: aDB.start_index,
                Difficulty: basePuzzle.currentDifficulty,
                Completed: basePuzzle.GetCompleteWords(),
                Total: basePuzzle.GetTotalWords()
//GS BUG# 3433                
            };
        } else
        {
            saveOBJ = {
                StartIndex: aDB.start_index,
                Difficulty: basePuzzle.currentDifficulty,
                Completed: basePuzzle.GetCompleteWords(),
                Total: basePuzzle.GetTotalWords()
            };
        }


        var cookieString = JSON.stringify(saveOBJ);
        //Set cookie
        this.setGameState(cookieString);

        //Notify user that game is saved
        $(this.defaults.gameStateLabel).html("Game saved");

        //Clear any existing timeout functions
        if (this.defaults.timeoutId)
            clearTimeout(this.defaults.timeoutId);

        //Set timeout to clear content
        setTimeout(function () {
            $(GameState.defaults.gameStateLabel).html("");
        }, GameState.defaults.timeoutDuration);
    },
    loadWordscrambler: function () {

        var cookieString = this.getGameState();

        if (cookieString && cookieString != 'undefined') {

            var saveOBJ = JSON.parse(cookieString);

            if (saveOBJ == null || saveOBJ == undefined)
                return;

            setTimeout(function ()
            {
                aDB.start_index = saveOBJ.StartIndex;
                basePuzzle.currentDifficulty = saveOBJ.Difficulty;

                basePuzzle.StartPuzzle();

                var totalWords = saveOBJ.Total;
                var completedWords = saveOBJ.Completed;

                if (totalWords != undefined)
                {
                    for (var i = 0; i < totalWords.length; i++) {

                        basePuzzle.CompleteWord(totalWords[i], true);

                        if (basePuzzle.IsRoundComplete())
                        {
                            basePuzzle.EndRound(true);
                        }

                        basePuzzle.ClearWord();
                    }
                }

                if (completedWords != undefined)
                {
                    for (var i = 0; i < completedWords.length; i++) {

                        basePuzzle.CompleteWord(completedWords[i], true);

                        if (basePuzzle.IsRoundComplete())
                        {
                            basePuzzle.EndRound(true);
                        }

                        basePuzzle.ClearWord();
                    }
                }


                $("#difficulty-menu").hide();
                $('#puzzle-dimmed-layer').hide();

            }, 200);
        }
    },
    loadWordscramblerDB: function () {

        var cookieString = this.getGameState();

        if (cookieString && cookieString != 'undefined') {

            var saveOBJ = JSON.parse(cookieString);

            if (saveOBJ == null || saveOBJ == undefined)
                return;

            setTimeout(function ()
            {
                aDB.start_index = saveOBJ.StartIndex;

                basePuzzle.StartPuzzle();

                var completedWords = saveOBJ.Completed;

                for (var i = 0; i < completedWords.length; i++) {

                    basePuzzle.CompleteWord(completedWords[i], true);
                }

            }, 200);
        }
    }

});