//Defines the top level Class
function Class() { }

Class.self = null;
Class.prototype.construct = function() { this.self = this; console.log("Override \"construct\" to ensure \"self\" staying the top object"); };
Class.extend = function(def) {
  var classDef = function() {
      if (arguments[0] !== Class) { this.construct.apply(this, arguments); }
  };
  
  var proto = new this(Class);
  var superClass = this.prototype;
 
  for (var n in def) {
      var item = def[n];                      
      if (item instanceof Function) item.$ = superClass;
      proto[n] = item;
  }
 
  classDef.prototype = proto;
 
  //Give this new class the same static extend method    
  classDef.extend = this.extend;      
  return classDef;
};


/**
 * Object definition for handling keyboard events for Crossword
 */
var WordWheelInput = $.extend(PuzzleInput, {
    /**
     * Returns true if a valid WordWheel input key is pressed (Letters)
     */
    isValidInput: function(event) {
        return ((event.keyCode >= 65 && event.keyCode <= 90) || (event.keyCode >= 97 && event.keyCode <= 122)
                || (event.which >= 65 && event.which <= 90) || (event.which >= 97 && event.which <= 122));
    }
});

var WordPuzzle = Class.extend({

    downScroll : null,
    scrollSettings :
    {
        background: "#c5c5c5",
        cursoropacitymin: 0.3,
        cursoropacitymax: 0.8,
        cursorwidth: "8px",
        scrollspeed: 100,
        autohidemode: true,
        touchbehavior: isClientMobile,
        usetransition: false,
        hwacceleration: true,
        enabletranslate3d: isClientMobile,
        preservenativescrolling: true
    },

    construct: function()
    {
        self = this;
    },

    Init: function()
    {
        self.UpdateOrientation();

        window.onorientationchange = function()
        {
            self.UpdateOrientation();
        };

        self.downScroll = $('#complete-words-container').niceScroll('#complete-words', self.scrollSettings);
    },

    UpdateOrientation: function ()
    {
        if (isClientiOS)
        {
            if (window.orientation == 0 || window.orientation == 180) {
                document.getElementById("viewport").setAttribute("content", "width=device-width, height=device-height, maximum-scale=1.0, initial-scale=1.0, user-scalable=no");
            }
            else
            {
                document.getElementById("viewport").setAttribute("content", "width=device-height, height=device-width, maximum-scale=1.0, initial-scale=1.0, user-scalable=no");
            }
        }
    },

    ErrorText: function(text,visible)
    {
        if(visible)
        {
            $('#error-description').html(text).css('visibility','visible');
        }
        else
        {
             $('#error-description').css('visibility','hidden');
        }

    },

    GetCompletionPercentage: function()
    {
      return 0;
    }

});