var CrosswordSolution = {
    init: function(adminEmail, allowIncompleteWord) {
        //CHECK SOLUTION BUTTON CLICK
        $(Puzzle.defaults.checkButton).click(function() {
            Puzzle.validateCellAnswers();
            
            //Show submit score dialog, if all the answers are correct
            if (Puzzle.checkAnswers()) {
                if (!puzzleId || puzzleId.length === 0) {
                    alert("This feature cannot be used in preview mode");
                    return;
                }
                
                if (isScoreEnabled) {
                    //Show submit score dialog, if all the answers are correct
                    showSubmitScore();
                }
                else {
                    Puzzle.showMessageBox("Congratulations! You have completed the puzzle.", Puzzle.messageType.INFO);
                }
                
                TrackPuzzle.analyticsEvent("puzzle", "end", "complete");
            }
        });
        
        //CHECK GAME COMPLETE BUTTON CLICK
        $(Puzzle.defaults.checkGameCompletionButton).click(function() {
            Puzzle.checkPuzzleCompletion();
        });

        // "HINT" BUTTON CLICK
        $(Puzzle.defaults.hintButton).click(function() {
            Puzzle.giveHint();
            TrackCs.flags |= CrosswordFlags.HINT;
        });

        // "WORD HINT" BUTTON CLICK
        $(Puzzle.defaults.wordHintButton).click(function() {
            Puzzle.giveWordHint();
            TrackCs.flags |= CrosswordFlags.HINT_WORD;
        });
        
        // "SUBMIT SCORE" BUTTON CLICK
        $(Puzzle.defaults.submitScoreButton).click(function() {
            Puzzle.invokeSubmitScore();
        });
        
        // "SHOW TOPLIST" BUTTON CLICK
        $(Puzzle.defaults.showToplistButton).click(function() {
            Puzzle.invokeToplist();
        }); 
        
        // "SOLVE PUZZLE" BUTTON CLICK
        $(Puzzle.defaults.solveButton).click(function() {
            Puzzle.solvePuzzle();
            TrackCs.flags |= CrosswordFlags.SOLUTION;
        });

        // "SEND SOLUTION" BUTTON CLICK
        $(Crossword.defaults.sendSolutionButton).click(function() {
            if (!puzzleId || puzzleId.length == 0) {
                alert("This feature cannot be used in preview mode");
                return;
            }
            
            if (adminEmail && adminEmail.length > 0) {
                var keyletters = $(Crossword.defaults.keywordInputId);
                var solution = "";

                for (var i = 0; i < keyletters.length; i++)
                {
                    var nextLetter = $(keyletters[i]).children(Crossword.defaults.cellInputId).html();
                    if (!nextLetter || nextLetter.length == 0) {
                        nextLetter = " ";
                        
                        if (!allowIncompleteWord) {
                            alert("You have to reveal all prizeword letters in order to send the solution!");
                            return;
                        }
                    }
                    
                    solution += nextLetter;
                }    

                var mailSubject = encodeURIComponent("Crossword Prizeword Solution");
                var mailBody = encodeURIComponent("Solution is: " + solution);
                window.open('mailto:' + adminEmail + '?subject=' + mailSubject + '&body=' + mailBody, "_self");
            }
            else {
                alert("No email is specified for this puzzle!");
            }
        });
        
        //SHOW - HIDE "SEND SOLUTION" BUTTON
        if ($(Crossword.defaults.keywordInputId).length == 0)
            $(Crossword.defaults.sendSolutionButton).hide();
    }
};