var CodewordSolution = {
    init: function() {
        //CHECK SOLUTION BUTTON CLICK
        $(Puzzle.defaults.checkButton).click(function() {
            Puzzle.validateCellAnswers();
            
            //Show submit score dialog, if all the answers are correct
            if (Puzzle.checkAnswers()) {
                if (!puzzleId || puzzleId.length === 0) {
                    alert("This feature cannot be used in preview mode");
                    return;
                }
                
                if (isScoreEnabled) {
                    //Show submit score dialog, if all the answers are correct
                    showSubmitScore();
                }
                else {
                    Puzzle.showMessageBox("Congratulations! You have completed the puzzle.", Puzzle.messageType.INFO);
                }
                
                TrackPuzzle.analyticsEvent("puzzle", "end", "complete");
            }
        });
        
        //CHECK GAME COMPLETE BUTTON CLICK
        $(Puzzle.defaults.checkGameCompletionButton).click(function() {
            Puzzle.checkPuzzleCompletion();
        });

        // "HINT" BUTTON CLICK
        $(Puzzle.defaults.hintButton).click(function() {
            Puzzle.giveHint();
            TrackCw.flags |= CodeWordFlags.HINT;
        });
        
        // "SUBMIT SCORE" BUTTON CLICK
        $(Puzzle.defaults.submitScoreButton).click(function() {
            Puzzle.invokeSubmitScore();
        });
        
        // "SHOW TOPLIST" BUTTON CLICK
        $(Puzzle.defaults.showToplistButton).click(function() {
            Puzzle.invokeToplist();
        }); 
        
        // "SOLVE PUZZLE" BUTTON CLICK
        $(Puzzle.defaults.solveButton).click(function() {
            Puzzle.solvePuzzle();
            TrackCw.flags |= CodeWordFlags.SOLUTION;
        });
    }
};