//Check HTC Android 2 built-in browser
var isAndroidHTC = navigator.userAgent.match(/HTC/i) && !navigator.userAgent.match(/Android 4/i);

/**
 * Object definition for handling keyboard events for Codeword
 */
var CodewordInput = $.extend(PuzzleInput, {
    /**
     * Returns true if a valid codeword input key is pressed (Letters)
     */
    isValidInput: function(event) {
        return ((event.keyCode >= 65 && event.keyCode <= 90) || (event.keyCode >= 97 && event.keyCode <= 122)
            || (event.which >= 65 && event.which <= 90) || (event.which >= 97 && event.which <= 122));
    }
});

var CodeWordFlags = {
    HINT: 1,
    SOLUTION: 2,
};

/**
 * Object definition for codeword
 */
var Codeword = $.extend(Puzzle, {
    solutionTimeout: -1,
    /**
     * Initializes components and event listeners for codeword
     * Currently, clue clicks, cell clicks and key inputs are
     * being listened by this class.
     */
    init: function(options) {
        //Get options
        $.extend(this.defaults, options);
        
        //Insert input field
        this.insertUserInputField();
        
        //Expose hint cells, inactivate letters on letter key
        $(Codeword.defaults.hintCellId).each(function() {
            var solution = $(this).children(Codeword.defaults.cellInputId).data("solution");
            $(this).children(Codeword.defaults.cellInputId).html(solution);
            
            //Type in the letter in grid & legend
            var cellNumber = $(this).data("number");
            $(".number" + cellNumber).addClass(Codeword.defaults.hintCellClass);
            $(".number" + cellNumber).children(Codeword.defaults.cellInputId).html(solution);
            
            //Inactivate the letter from letter key
            $(Codeword.defaults.letterKeyId + " .letter" + solution).addClass(Codeword.defaults.hintCellClass);
            $(Codeword.defaults.letterKeyId + " .letter" + solution).addClass(Codeword.defaults.inactiveCellClass);
        });
        
        //Set parent objects
        this.parentObjects.grid = $(this.defaults.gridId);
        
        //CELL CLICKS
        $(this.defaults.cellsId).click(function(event) {
            if (!$(this).hasClass(Codeword.defaults.blankClass))
            {                
                //Determine if the source of event is user click
                if (event.originalEvent) 
                    Codeword.cellEventSource = EventSource.CellClick;

                //Deselect old cells
                Codeword.deselectCells();
                //Select cell logically
                Codeword.selectCluesForCell(this);
                //Mark input cell
                Codeword.hightlightInputCell(this);
                //Reposition user input field according to cell
                Codeword.repositionUserInputField();
                //Enable user input
                $(Codeword.defaults.userInputId).focus();
                
                //Update selected group index
                if (Codeword.shouldAnswerSlotChange()) {
                    Codeword.lastSelected.cellGroupIndex = Codeword.findCellIndexInGroup(Codeword.lastSelected.cell, Codeword.lastSelected.cellGroup);
                }
            }
        });


        var androidChrome = (navigator.userAgent.toLowerCase().indexOf("android") > -1 && navigator.userAgent.toLowerCase().indexOf("chrome") > -1);

        if (androidChrome)
        {
            //Backspace and arrow keys should be handled with "keydown"
            $(this.defaults.userInputId).keyup(function(event) {
                //Get user input
                var inputLastChar = CodewordInput.getUserInput(event, Codeword.defaults.userInputId);
                
                if (CodewordInput.isBackspace(event)) 
                {
                    //Backspace
                    if (!$(Codeword.lastSelected.cell).hasClass(Codeword.defaults.hintCellClass))
                    {
                        //Set cell text to empty value
                        Codeword.setCellValue(Codeword.lastSelected.cell, "");
                    }
                    
                    //Focus previous cell
                    Codeword.focusPrevInputCell();
                }
                else if (CodewordInput.isUp(event)) 
                {
                    //Up arrow
                    Codeword.focusCellAtDirection(Codeword.lastSelected.cell, PuzzleDirection.UP);
                }
                else if (CodewordInput.isRight(event)) 
                {
                    //Right arrow
                    Codeword.focusCellAtDirection(Codeword.lastSelected.cell, PuzzleDirection.RIGHT);
                }
                else if (CodewordInput.isDown(event)) 
                {
                    //Down arrow
                    Codeword.focusCellAtDirection(Codeword.lastSelected.cell, PuzzleDirection.DOWN);
                }
                else if (CodewordInput.isLeft(event)) 
                {
                    //Left arrow
                    Codeword.focusCellAtDirection(Codeword.lastSelected.cell, PuzzleDirection.LEFT);
                }
                
                if (CodewordInput.isValidInput(event)) 
                {
                    var canType = true;
                    if (!$(Codeword.lastSelected.cell).hasClass(Codeword.defaults.hintCellClass))
                    {
                        //Set cell text to inputted value
                        canType = Codeword.setCellValue(Codeword.lastSelected.cell, inputLastChar);
                    }
                    
                    //Focus next cell
                    if (canType)
                        Codeword.focusNextInputCell();
                }
                else
                {
                //console.log("Key is not valid!");
                }
            });
        }
        else
        {
            //Backspace and arrow keys should be handled with "keydown"
            $(this.defaults.userInputId).keydown(function(event) {
                //Get user input
                CodewordInput.getUserInput(event, Codeword.defaults.userInputId);
                
                if (CodewordInput.isBackspace(event)) 
                {
                    //Backspace
                    if (!$(Codeword.lastSelected.cell).hasClass(Codeword.defaults.hintCellClass))
                    {
                        //Set cell text to empty value
                        Codeword.setCellValue(Codeword.lastSelected.cell, "");
                    }
                    
                    //Focus previous cell
                    Codeword.focusPrevInputCell();
                }
                else if (CodewordInput.isUp(event)) 
                {
                    //Up arrow
                    Codeword.focusCellAtDirection(Codeword.lastSelected.cell, PuzzleDirection.UP);
                }
                else if (CodewordInput.isRight(event)) 
                {
                    //Right arrow
                    Codeword.focusCellAtDirection(Codeword.lastSelected.cell, PuzzleDirection.RIGHT);
                }
                else if (CodewordInput.isDown(event)) 
                {
                    //Down arrow
                    Codeword.focusCellAtDirection(Codeword.lastSelected.cell, PuzzleDirection.DOWN);
                }
                else if (CodewordInput.isLeft(event)) 
                {
                    //Left arrow
                    Codeword.focusCellAtDirection(Codeword.lastSelected.cell, PuzzleDirection.LEFT);
                }
            });
            
            //USER INPUT should be handled with "keypress"
            $(this.defaults.userInputId).keypress(function(event) {
                //Get user input
                var inputLastChar = CodewordInput.getUserInput(event, Codeword.defaults.userInputId);
                
                if (CodewordInput.isValidInput(event)) 
                {
                    var canType = true;
                    if (!$(Codeword.lastSelected.cell).hasClass(Codeword.defaults.hintCellClass))
                    {
                        //Set cell text to inputted value
                        canType = Codeword.setCellValue(Codeword.lastSelected.cell, inputLastChar);
                    }
                    
                    //Focus next cell
                    if (canType)
                        Codeword.focusNextInputCell();
                }
                else
                {
                //console.log("Key is not valid!");
                }
            });
        }
    },
    /**
     * Inserts an input field to web page for user input
     */
    insertUserInputField: function() {
        var userInput = document.createElement("input");
        userInput.id = this.defaults.userInputId.replace("#", "");
        userInput.type = "text";
        userInput.maxlength = "1";
        userInput.spellcheck = "false";
        userInput.style.top = "-10000px";
        userInput.style.width = "10px";
        userInput.style.height = "10px";
        userInput.style.fontSize = "1px";
        userInput.style.textTransform = "uppercase";
        userInput.style.position = "absolute";
        userInput.style.zIndex = "-9999";
        userInput.style.marginLeft = "20px";
        document.body.innerHTML = userInput.outerHTML + document.body.innerHTML;
    },
    repositionUserInputField: function() {
        //Scroll to input cell
        if (/*typeof(isClientMobile) !== undefined && isClientMobile && */this.lastSelected.cell) {
            $(this.defaults.userInputId).css("top", $(this.lastSelected.cell).offset().top);
            $(this.defaults.userInputId).css("left", $(this.lastSelected.cell).offset().left);
        }
    },
    /**
     * Invokes cell click event programatically
     */
    invokeCellClick: function(cell, eventSource) {
        this.cellEventSource = eventSource;
        $(cell).click();
    },
    /**
     * Determines if answer slot should change during the event, depending on the event source
     */
    shouldAnswerSlotChange: function() {
        if (this.cellEventSource == EventSource.CellClick || this.cellEventSource == EventSource.ClueClick)
            return true;
        return false;
    },
    /**
     * Highlights the cell that takes user input
     */
    hightlightInputCell: function(cell) {
        $(cell).addClass(this.defaults.selectedClass);
        this.lastSelected.cell = cell;
        
        //Highlight related cells
        var cellNumber = $(this.lastSelected.cell).data("number");
        $(".number" + cellNumber).addClass(this.defaults.selectedClass);
    },
    /**
     * Removes the highlight from selected cell & answer slot
     */
    deselectCells: function() {
        //Remove highlight from input cell
        if (this.lastSelected.cell != undefined)
        {
            //Remove highlight from selected
            $(this.lastSelected.cell).removeClass(this.defaults.selectedClass);
            
            //Remove highlight from related cells
            var cellNumber = $(this.lastSelected.cell).data("number");
            $(".number" + cellNumber).removeClass(this.defaults.selectedClass);
            
            //Reset last selected cell selection
            this.lastSelected.cell = undefined;
        }
        
        //If this is caused by a mouse event, remove highlight from answer slot
        if (this.shouldAnswerSlotChange())
        {
            for (var i = 0; i < this.lastSelected.cellGroup.length; i++)
            {
                var cellX = this.lastSelected.cellGroup[i][0];
                var cellY = this.lastSelected.cellGroup[i][1];
                $("#cell-" + cellX + "-" + cellY).removeClass(this.defaults.selectedGroupClass);
            }
            
            //Reset selected group
            this.lastSelected.cellGroup = new Array();
        }
    },
    /**
     * Selects the related clues. For cells on the intersection of two answers, two clues will be selected.
     * Clues can also have related clues, so they will also be highlighted.
     */
    selectCluesForCell: function(cell) {
        //Get clues of the selected cell
        var clueIds = $(cell).data("clueid").toString().split("-");
        
        //If this is performed on a cell that is already reverted,
        //then take array in natural order. Otherwise revert the array, and mark the cell as reverted.
        if ($(cell).data("reverted") == 1)
        {
            $(cell).data("reverted", 0);
        }
        else
        {
            $(cell).data("reverted", 1);
            clueIds.reverse();
        }
        
        //One answer slot will be selected
        var asnwerSlotSelected = false;
        //Cells might be linked to more than one clue.
        //For each clue, highlight clue element & select answer slot
        for (var i = 0; i < clueIds.length; i++)
        {            
            //Next clue selector
            var clue = codewordClues[clueIds[i]];
            //Select clue, and trigger clue tracking only for the first round of the loop
            this.selectClue(clue, (i == 0));
            
            //Select answer slot
            if (!asnwerSlotSelected && this.selectAnswerSlot(clue))
                asnwerSlotSelected = true;
        }
    },
    /**
     * Highlights ad logically selected the answer slot for user input.
     * Selected cells are stored in cell group variable, so they can be accessed for any operation.
     */
    selectAnswerSlot: function(clue) {
        //If the source is not a mouse event, then don't change answer slot
        if (!this.shouldAnswerSlotChange())
            return true;
        
        //Get all cell coordinates for clue answer
        var x1 = this.getClueProperty(clue, "x1");
        var x2 = this.getClueProperty(clue, "x2");
        var y1 = this.getClueProperty(clue, "y1");
        var y2 = this.getClueProperty(clue, "y2");
        var direction = this.getClueProperty(clue, "direction");

        if (direction == "across")
        {
            for (var xCor = x1; xCor <= x2; xCor++)
            {
                $("#cell-" + xCor + "-" + y1).addClass(this.defaults.selectedGroupClass);
                this.lastSelected.cellGroup.push(new Array(xCor, y1));
            }    
        }
        else if (direction == "down")
        {
            for (var yCor = y1; yCor <= y2; yCor++)
            {
                $("#cell-" + x1 + "-" + yCor).addClass(this.defaults.selectedGroupClass);
                this.lastSelected.cellGroup.push(new Array(x1, yCor));
            }
        }

        return true;
    },
    /**
     * Highlight a clue and all the other clues related to it
     */
    selectClue: function(clue, shouldTriggerTracking) {        
        //Do tracking only if clue change was caused by click event and answer slot has changed
        if (shouldTriggerTracking && this.shouldAnswerSlotChange())
            TrackCw.saveClueStartTime(clue);
    },
    /**
     * Gets a data attribute of a clue element
     */
    getClueProperty: function(clue, cId) {
        return clue[cId];
    },
    /**
     * Sets the value of a cell by setting inner HTML
     */
    setCellValue: function(cell, val) {
        //Get previous value
        var prevValue = $(cell).children(Codeword.defaults.cellInputId).html();
        
        //Set original cell value
        if (prevValue != val && $(Codeword.defaults.letterKeyId + " .letter" + val).hasClass(Codeword.defaults.inactiveCellClass)) {
            //Show warning if the letter is already used
            $(Codeword.defaults.letterKeyId + " .letter" + val).addClass(Codeword.defaults.invalidCellClass);
            
            //Remove warning after 1 second
            setTimeout(function() {
                $(Codeword.defaults.letterKeyId + " .letter" + val).removeClass(Codeword.defaults.invalidCellClass);
            }, 1000);
            
            return false;
        }
        
        $(cell).children(Codeword.defaults.cellInputId).html(val);
        $(cell).removeClass(this.defaults.invalidCellClass);

        //Set related cell values
        var cellNumber = $(cell).data("number");
        $(".number" + cellNumber).children(Codeword.defaults.cellInputId).html(val);
        $(".number" + cellNumber).removeClass(Codeword.defaults.invalidCellClass);
        
        
        //Inactivate previous letter key
        if (prevValue.length > 0)
            $(Codeword.defaults.letterKeyId + " .letter" + prevValue).removeClass(Codeword.defaults.inactiveCellClass);
        
        //Activate current letter key
        if (val.length > 0)
            $(Codeword.defaults.letterKeyId + " .letter" + val).addClass(Codeword.defaults.inactiveCellClass);
        
        if(val != ''){
            Codeword.createSolutionTimeout(Codeword, Codeword.solutionTimeout);}  

        return true;
    },
    /**
     * Finds the indice of a given cell in the given cell group
     */
    findCellIndexInGroup: function(cell, cellGroup, minValue) {
        if (!minValue)
            minValue = 0;
        
        //Get cell coordinates
        var cellDetails = cell.id.toString().split("-");
        var cellX = parseInt(cellDetails[1]);
        var cellY = parseInt(cellDetails[2]);

        //Find selected cell in the group
        for (var index = 0; index < cellGroup.length; index++)
        {
            var curX = this.lastSelected.cellGroup[index][0];
            var curY = this.lastSelected.cellGroup[index][1];
            
            if (index >= minValue && cellX == curX && cellY == curY) {
                return index;
            }    
        }
        
        return -1;
    },
    /**
     * Focuses next cell for user input. This function is used when user fills in an answer slot.
     */
    focusNextInputCell: function() {
        //Check if current cell is defined
        if (this.lastSelected.cell != undefined)
        {
            //To make while loop fail-safe, we limit try count
            var tryCount = 2;
            
            do {
                tryCount--;
                
                //Get cell coordinates
                var index = this.findCellIndexInGroup(this.lastSelected.cell, 
                    this.lastSelected.cellGroup, 
                    this.lastSelected.cellGroupIndex);
                index++;

                if (index < this.lastSelected.cellGroup.length)
                {
                    var nextCellId = "#cell-" + this.lastSelected.cellGroup[index][0]
                    + "-" + this.lastSelected.cellGroup[index][1];
                    this.invokeCellClick(nextCellId, EventSource.KeyInput);
                    Codeword.lastSelected.cellGroupIndex++;
                }
            }
            while (index < this.lastSelected.cellGroupIndex && tryCount > 0);
        }
    },
    /**
     * Focuses next cell for user input. This function is used when user deletes an answer slot with backspace.
     */
    focusPrevInputCell: function() {
        //Check if current cell is defined
        if (this.lastSelected.cell != undefined)
        {
            //To make while loop fail-safe, we limit try count
            var tryCount = 2;
            
            do {
                tryCount--;
                
                //Get cell coordinates
                var index = this.findCellIndexInGroup(this.lastSelected.cell, 
                    this.lastSelected.cellGroup, 
                    this.lastSelected.cellGroupIndex);
                index--;

                if (index >= 0)
                {
                    var prevCellId = "#cell-" + this.lastSelected.cellGroup[index][0]
                    + "-" + this.lastSelected.cellGroup[index][1];
                    this.invokeCellClick(prevCellId, EventSource.KeyInput);
                    Codeword.lastSelected.cellGroupIndex--;
                }
            }
            while (index < this.lastSelected.cellGroupIndex && tryCount > 0);
        }
    },
    /**
     * Focuses next cell for user input. This function is used when user fills in an answer slot.
     */
    focusCellAtDirection: function(cell, direction) {
        //Get cell coordinates
        var cellDetails = $(cell).attr("id").toString().split("-");
        var cellX = parseInt(cellDetails[1]);
        var cellY = parseInt(cellDetails[2]);
        
        //Determine the new cell coordinates based on given direction
        if (direction == PuzzleDirection.UP)
            cellY = ((cellY - 1) <= 0) ? Puzzle.size.height : (cellY - 1);
        else if (direction == PuzzleDirection.RIGHT)
            cellX = ((cellX + 1) > Puzzle.size.width) ? 1 : (cellX + 1);
        else if (direction == PuzzleDirection.DOWN)
            cellY = ((cellY + 1) > Puzzle.size.height) ? 1 : (cellY + 1);
        else if (direction == PuzzleDirection.LEFT)
            cellX = ((cellX - 1) <= 0) ? Puzzle.size.width : (cellX - 1);
        
        var nextCellId = "#cell-" + cellX + "-" + cellY;
        var nextCell = $(nextCellId);
        
        //If neighbour cell is blank, try next
        if (nextCell.hasClass(Codeword.defaults.blankClass)) {
            Codeword.focusCellAtDirection(nextCell, direction);
            return;
        }
        
        this.invokeCellClick(nextCellId, EventSource.CellClick);
    },
    moveToNextHintCell: function() {
        var cellX = 1;
        var cellY = 1;
        
        //Get cell coordinates
        if (Puzzle.lastSelected.cellGroup) {
            //Find cell in the group
            var selectedIndex = Codeword.findCellIndexInGroup(Puzzle.lastSelected.cell, Puzzle.lastSelected.cellGroup);
            if (selectedIndex < 0)
                selectedIndex = 0;
            else if (selectedIndex + 1 < Puzzle.lastSelected.cellGroup.length)
                selectedIndex++;
            
            cellX = parseInt(Puzzle.lastSelected.cellGroup[selectedIndex][0]);
            cellY = parseInt(Puzzle.lastSelected.cellGroup[selectedIndex][1]);
        }
        
        var nextCellId = "#cell-" + cellX + "-" + cellY;
        this.invokeCellClick(nextCellId, EventSource.KeyInput);
    },
    solvePuzzle: function() {
        var hintNumber = 0;
        
        $(Puzzle.defaults.cellsId).each(function() {
            $(this).removeClass(Puzzle.defaults.invalidCellClass);
            
            //Get solution and current value
            var solution = $(this).children(Puzzle.defaults.cellInputId).data("solution");
            var currentVal = $(this).children(Puzzle.defaults.cellInputId).html();
            
            //For each wrong or incomplete answer, set solution
            if (solution != currentVal) {
                $(this).children(Puzzle.defaults.cellInputId).html(solution);
                hintNumber++;
            }
            
            //Show solution in legend
            var cellNumber = $(this).data("number");
            $(".number" + cellNumber).children(Codeword.defaults.cellInputId).html(solution);
            
            //Inactivate the letters from letter key
            $(Codeword.defaults.letterKeyId + " .letter" + solution).addClass(Codeword.defaults.inactiveCellClass);
        });
        
        //Penalize user for using each incorrect or incomplete button
        if (puzzleTimer)
            puzzleTimer.addSeconds(hintNumber * 10);

        Codeword.createSolutionTimeout();
    },

    fixHeightHTCAndroid: function()
    {
        if (isAndroidHTC) {
            setTimeout(function() {
                var heightRequired = $("#puzzle-grid").height();
                
                if ($(".banner-image").length > 0)
                    heightRequired += $(".banner-image").height();

                //Add keyboard height
                heightRequired += 400;
                //Set body height
                $("body").height(heightRequired);
            }, 1000);
        }
    }
});

//Code block to fix mobile UX
var zoomLevel = 1;
$(document).ready(function() {
    Puzzle.updateOrientation();
    window.onorientationchange = function() {
        Puzzle.updateOrientation();
    }
    
    var puzzleMax = parseInt($('.puzzle').outerHeight(true));
    var puzzleLegendMax = parseInt($('#puzzle-legend').outerHeight(true));
    var puzzleMaxWidth = parseInt($('.puzzle').css('Width'));
    var puzzleWrapperHeight = parseInt($('.puzzle-wrapper').outerHeight(true));
	
    function hintFixed() {
//        $('.puzzle-wrapper').css('height', puzzleWrapperHeight+55);
//        $('#puzzle-legend').css({
//            position: 'fixed',
//            bottom: '0',
//            margin: '0 0 0 -196px',
//            left: '50%'
//        });
    }
    
    function hintStatic() {
//        $('.puzzle-wrapper').css('height', puzzleWrapperHeight);
//        $('#puzzle-legend').css({
//            position: 'static',
//            margin: '20px auto'
//        });
    }
    
    function fitPuzzle(userZoom) {
        var zoomLevel = userZoom || false;
        
        if (!zoomLevel) {
            zoomLevel = (window.innerWidth / puzzleMaxWidth) - 0.035; // some margin to the right side
            var realZoomLevel = zoomLevel;
            zoomLevel = (0.7 > zoomLevel) ? 0.7 : zoomLevel; // minimum zoom 0.7
            zoomLevel = (zoomLevel > 1) ? 1 : zoomLevel; // max zoom 1
        }
        
        var fontTopMargin = (zoomLevel * 8) * 0.7;
        
        if($(window).height() > ((puzzleMax * zoomLevel) + puzzleLegendMax + 10)) {
            hintStatic();
        }
        else {
            hintFixed();
        }
        
        // cell sizing
        if (window.innerWidth < puzzleMaxWidth)
        {
            $('.puzzle, #puzzle-legend').css({
                zoom: zoomLevel
            });
        } else {
            $('.puzzle, #puzzle-legend').css({
                zoom: 1
            });
        }
        
        if (zoomLevel < 1) {
            $('#puzzle-grid .cell-number, #puzzle-grid .cell-input').css({
                zoom: zoomLevel
            });
        }
        else {
            $('#puzzle-grid .cell-number').css({
                zoom: 1
            });
        }
        
        if (6 > realZoomLevel) {
            $('#puzzle-grid .cell-number').css({
                top: -fontTopMargin
            });
        }
        else {
            $('#puzzle-grid .cell-number').css({
                top: -8
            });
        }
        
        if (Puzzle.repositionUserInputField) {
            Puzzle.repositionUserInputField();
        }
        
        Codeword.fixHeightHTCAndroid();
    }
//GS BUG#2254   
//    setTimeout(fitPuzzle, 10);
//    var resizeMe;
//    $(window).resize(function()
//    {
//        // lets make sure we only run th function once after a 100 ms timeout (cheap onResizeEnd)
//        clearTimeout(resizeMe);
//        resizeMe = setTimeout(fitPuzzle, 100);
//    });
//GS BUG#2254
    
    function throttle(fn, threshhold, scope) {
        threshhold || (threshhold = 250);
        var last,
        deferTimer;
        return function () {
            var context = scope || this;

            var now = +new Date,
            args = arguments;
            if (last && now < last + threshhold) {
                // hold on to it
                clearTimeout(deferTimer);
                deferTimer = setTimeout(function () {
                    last = now;
                    fn.apply(context, args);
                }, threshhold);
            } else {
                last = now;
                fn.apply(context, args);
            }
        };
    }

    //Zoom buttons
    setTimeout(function() {
        $(Codeword.defaults.zoomInButton).click(function() {
            var zoomLevel = parseFloat($(Puzzle.defaults.gridId).css("zoom"));
            fitPuzzle(2);
           });
	    
        $(Codeword.defaults.zoomOutButton).click(function() {
            var zoomLevel = parseFloat($(Puzzle.defaults.gridId).css("zoom"));
	        
            if (!zoomLevel || zoomLevel.length == 0)
                zoomLevel = 1;

            if (zoomLevel == 1)
                fitPuzzle();
	        
            if (zoomLevel > 1) {
                zoomLevel -= 0.1;
                $(Puzzle.defaults.gridId).css("zoom", zoomLevel);
            }
        });
    }, 10);
});